import React from 'react';

const StyleInjector: React.FC = () => (
    <style>{`
      @keyframes pulse {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.7; }
      }
      .animate-pulse-slow {
        animation: pulse 2.5s cubic-bezier(0.4, 0, 0.6, 1) infinite;
      }
    `}</style>
  );

export const GenerationInProgress: React.FC = () => {
  return (
    <>
    <StyleInjector />
    <div className="flex flex-col items-center justify-center p-8 min-h-[450px] text-center transition-opacity duration-500">
      <svg className="animate-spin h-12 w-12 text-indigo-400 mb-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
        <circle className="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" strokeWidth="4"></circle>
        <path className="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
      </svg>
      <h2 className="text-2xl font-bold text-white mb-2 animate-pulse-slow">Building Your App...</h2>
      <p className="text-slate-400 max-w-sm">
        Please wait a moment while Gemini generates your Android project files. This can take up to a minute.
      </p>
    </div>
    </>
  );
};
